<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\AcceptTaskHeadline;
use App\Models\Admin\Website;
use App\Models\CompleteTaskHeadline;
use App\Models\Job;
use App\Models\JobWork;
use App\Models\JobHide;
use App\Models\JobReport;
use App\Models\User;
use App\Models\Admin\UserMessage;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class UserJobWorkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     
  

    public function index()
    {
        $datas = JobWork::where('user_id', Auth::user()->id)->latest()->take(400)->get();
    
        // Fetch the associated job for each worked job
        $jobs = $datas->map(function ($data) {
            return Job::find($data->job_id);
        });
    
        $headlines = CompleteTaskHeadline::all();
        $title = 'Complete Worked Job List';
    
        return view('user.pages.worked-job-list', compact('title', 'datas', 'headlines', 'jobs'));
    }

    
    public function complete()
    {
        $datas = JobWork::where('job_woner', Auth::user()->id)->latest()->paginate(25);
        $headlines = AcceptTaskHeadline::all();
        $title = 'Worked Job List';

        return view('user.pages.accept-worked-job-list', compact('title', 'datas', 'headlines'));
    }


    public function job_working_proves($code)
    {
        $job = Job::where('code', $code)->first();
        $datas = JobWork::where('job_id', $job->id)->latest()->take(2000)->get();
        $headlines = AcceptTaskHeadline::all();
        
        $title = 'Worked Job List';

        return view('user.pages.accept-worked-job-prove-list', compact('title', 'job', 'datas', 'headlines'));
    }

    public function all_satisfied()
    {
        $works = JobWork::where('status', 0)->where('job_woner', Auth::user()->id)->latest()->get();
        foreach($works as $work){
            $job_work = JobWork::find($work->id);
            if($job_work){
                $job = Job::find($job_work->job_id);
                if($job){
                    $user = User::find($job_work->user_id);
                    $user->earning_balance = $user->earning_balance + $job->each_worker_earn;
            
                    $website = Website::latest()->first();
                    if($website->referral_earning_commission > 0){
                        $earning_commission = ($website->referral_earning_commission * $job->each_worker_earn) / 100;
            
                        $refered_by = User::find($user->rfered_by);
                        if($refered_by){
                            $refered_by->earning_balance = $refered_by->earning_balance + $earning_commission;
                            $refered_by->save();
                
                            $user->earning_commision_from_refer = $user->earning_commision_from_refer + $earning_commission;
                        }
                    }
            
                    $user->save();
            
                    $job->worker_confirmed = $job->worker_confirmed + 1;
            
                    $job_work->status = 1;
                    $job_work->save();
            
                    $job->save();
                }
            }else{
                $job_work->delete();
            }
        }
        
        $datas = JobWork::where('user_id', Auth::user()->id)->latest()->paginate(25);
        $headlines = AcceptTaskHeadline::all();
        $title = 'Satisfied Worked List';

        return view('user.pages.accept-worked-job-list', compact('title', 'datas', 'headlines'));
    }

    public function all_satisfied_of_job($job_id)
    {
        $works = JobWork::where('status', 0)->where('job_id', $job_id)->where('job_woner', Auth::user()->id)->latest()->get();
    
        foreach ($works as $work) {
            $job_work = JobWork::find($work->id);
    
            if ($job_work) {
                $job = Job::find($job_work->job_id);
    
                if ($job) {
                    $user = User::find($job_work->user_id);
                    $user->earning_balance = $user->earning_balance + $job->each_worker_earn;
    
                    $website = Website::latest()->first();
    
                    if ($website->referral_earning_commission > 0) {
                        $earning_commission = ($website->referral_earning_commission * $job->each_worker_earn) / 100;
    
                        $refered_by = User::find($user->rfered_by);
    
                        if ($refered_by) {
                            $refered_by->earning_balance = $refered_by->earning_balance + $earning_commission;
                            $refered_by->save();
    
                            $user->earning_commision_from_refer = $user->earning_commision_from_refer + $earning_commission;
    
                            // Message for referral commission
                            $commissionMessage = new UserMessage();
                            $commissionMessage->user_id = $refered_by->id;
                            $commissionMessage->message_title = 'TASK_COMMISSION';
                            $commissionMessage->message = 'Congrats! You Got $' . number_format($earning_commission, 4) . ' For Refer Commission.';
                            $commissionMessage->save();
                        }
                    }
    
                    $user->save();
                    $job->worker_confirmed = $job->worker_confirmed + 1;
                    $job_work->status = 1;
                    $job_work->save();
                    $job->save();
                }
            } else {
                // If the job work is not found, delete it
                $job_work->delete();
            }
        }
    
        $datas = JobWork::where('user_id', Auth::user()->id)->latest()->paginate(2500);
        $headlines = AcceptTaskHeadline::all();
        $title = 'Satisfied Worked List';
    
      //  return view('user.pages.accept-worked-job-list', compact('title', 'datas', 'headlines'));
        return redirect()->back()->with('message','All Prove Satisfied Successfully');
    }

    
    public function job_work_approve($id)
    {
        $job_work = JobWork::find($id);
    
        $msg_user_id = $job_work->user_id;
    
        $job = Job::find($job_work->job_id);
        $msg_title = $job->title;
    
        $job_code = $job->code;
    
        $user = User::find($job_work->user_id);
        $user->earning_balance = $user->earning_balance + $job->each_worker_earn;
    
        $website = Website::latest()->first();
        if ($website->referral_earning_commission > 0) {
            $earning_commission = ($website->referral_earning_commission * $job->each_worker_earn) / 100;
    
            $refered_by = User::find($user->rfered_by);
            if ($refered_by) {
                $refered_by->earning_balance = $refered_by->earning_balance + $earning_commission;
                $refered_by->save();
    
                $user->earning_commision_from_refer = $user->earning_commision_from_refer + $earning_commission;
    
                // Message for referral commission
                $commissionMessage = new UserMessage();
                $commissionMessage->user_id = $refered_by->id;
                $commissionMessage->message_title = 'TASK_COMMISSION';
                $commissionMessage->message = 'Congrats! You Got $' . number_format($earning_commission, 4) . ' For Refer Commission.';
                $commissionMessage->save();
            }
        }
    
        $user->save();
    
        $job->worker_confirmed = $job->worker_confirmed + 1;
    
        $job_work->status = 1;
        $job_work->save();
    
        $job->save();
    
        // Message for task approval
      //  $approvalMessage = new UserMessage();
     //   $approvalMessage->user_id = $msg_user_id;
     //   $approvalMessage->message_title = 'TASK_APPROVED';
     //   $approvalMessage->message = 'Task approved of the job: ' . $msg_title;
     //   $approvalMessage->save();
     
    
        return redirect()->back()->with('message','Successfully approve this prove!');
    }

    
    public function job_work_reject(Request $request, $id)
    {
        $job_work = JobWork::find($id);
        $msg_user_id = $job_work->user_id;
        
        $job_work->status = 2;
        $job_work->reason = $request->reason;

        $job = Job::find($job_work->job_id);
        $msg_title = $job->title;
        
        $reject_done = $job->reject_done + 1;
        $job->reject_done = $reject_done;
        $job->save();

        $job_work->save();
        
     //   $data = new UserMessage();
     //   $data->user_id = $msg_user_id;
    //    $data->message_title = 'TASK_REJECTED';
    //    $data->message = 'Task rejected of the job: '.$msg_title.'. Reason: '.$request->reason;
    //    $data->save();
    
    //$request->session()->flash('approve_error', true);

        return redirect()->back()->with('message','Successfully reject this prove!');
    }

    public function job_work_report(Request $request, $id)
    {
        $job_work = JobWork::find($id);
        $msg_user_id = $job_work->user_id;

        $job = Job::find($job_work->job_id);
        $msg_title = $job->title;
        
        $job_work->status = 3;
        $job_work->report_to_admin = $request->report_to_admin;
        $job_work->report_reason = $request->report_reason;
        $job_work->save();
        
        $data = new UserMessage();
        $data->user_id = $msg_user_id;
        $data->message_title = 'TASK_REPORTED';
        $data->message = 'You got report for → '.$msg_title.'.Reason: '.$request->report_reason;
        $data->save();

        return redirect()->back()->with('message','Successfully report this job!');
    }

    public function job_work_resume(Request $request, $id)
    {
        $job_work = JobWork::find($id);
        $msg_user_id = $job_work->user_id;

        $job = Job::find($job_work->job_id);
        $msg_title = $job->title;
        
        $job_work->status = 4;
        $job_work->reason = $request->reason;
        $job_work->save();
        
        $data = new UserMessage();
        $data->user_id = $msg_user_id;
        $data->message_title = 'Work Resume';
        $data->message = 'Work resumed for the job of '.$msg_title.'. Reason: '.$request->reason;
        $data->save();

        return redirect()->back()->with('message','Successfully resumed this job!');
    }

    public function job_work_rate(Request $request, $id){
        $job_work = JobWork::find($id);
        
        $msg_user_id = $job_work->user_id;
        $job = Job::find($job_work->job_id);
        $msg_title = $job->title;
        
        $job_work->is_rated = 1;
        $job_work->rating = $request->rate;
        $job_work->save();
        
        $data = new UserMessage();
        $data->user_id = $msg_user_id;
        $data->message_title = 'PROVE_RATING';
        $data->message = 'Congratulations, You Got '.$request->rate.'-Star Rating From: '.$msg_title;
        $data->save();
        
        return redirect()->back()->with('message','Successfully rated this Prove!');
    }


    public function job_work_give_tips(Request $request, $id){
        // Validate tips amount
        $validatedData = $request->validate([
            'tipsAmount' => 'required|numeric|min:0.1|max:1',
        ]);
    
        if(Auth::user()->deposit_balance < $validatedData['tipsAmount']){
            return redirect()->back()->with('error','Sorry! Insufficient balance');
        }else{
            $job_work = JobWork::find($id);
            $msg_user_id = $job_work->user_id;
            $job = Job::find($job_work->job_id);
            $msg_title = $job->title;
    
            $user = User::find($msg_user_id);
            $user->earning_balance = $user->earning_balance + $validatedData['tipsAmount'];
            $user->save();
    
            $user = User::find(Auth::user()->id);
            $user->deposit_balance = $user->deposit_balance - $validatedData['tipsAmount'];
            $user->save();
    
            session(['tips_given_' . $id => true]);
    
            $data = new UserMessage();
            $data->user_id = $msg_user_id;
            $data->message_title = 'TIPS_RECEIVE';
            $data->message = 'Congratulations, You Receive $'.$validatedData['tipsAmount'].' Tips From: '.$msg_title;
            $data->save();
            return redirect()->back()->with('message','Tips send success');
            
        }
    }

    public function job_work_report_to_job_woner(Request $request, $id)
    {
        $job_work = JobWork::find($id);
        $msg_user_id = $job_work->job_woner;

        $job = Job::find($job_work->job_id);
        $msg_title = $job->title;
        
        $job_work->job_woner_report = 1;
        $job_work->job_woner_report_reason = $request->reason;
        $job_work->save();
        
        $data = new UserMessage();
        $data->user_id = $msg_user_id;
        $data->message_title = 'Work Report';
        $data->message = 'Reported for the job of '.$msg_title.'. Reason: '.$request->report_reason;
        $data->save();

        return redirect()->back()->with('message','Successfully report this job!');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    
    public function job_hide($job_id)
    {
        $job_hide = new JobHide();
        $job_hide->job_id = $job_id;
        $job_hide->user_id = Auth::user()->id;
        $job_hide->save();
        
        return redirect()->route('user.find-job')->with('message','Successfully this job hide!');
    }
    
  public function report_this_job(Request $request){
    $request->validate([
        'job_id' => 'required',
        'report_describe' => 'required',
    ]);
    
    $job = Job::find($request->job_id);
    
    $msg_title = $job->title;
    
    $work = new JobReport();
    $work->job_id = $request->job_id;
    $work->user_id = Auth::user()->id;
    $work->report = $request->report_describe;
    $work->save();

    // Add a message to the user who reported the job
    //$data = new UserMessage();
    //$data->user_id = Auth::user()->id;
    //$data->message_title = 'TASK_REPORT';
    //$data->message = 'Thank you for your report: ( ' . $request->report_describe . ' )  of the Job: ' . $msg_title;
    
    return redirect()->back()->with('message','Successfully reported this job!');
}

    public function job_task_report(Request $request, $id)
    {
        $request->validate([
            'report_describe' => 'required',
        ]);
    
        $job_work = JobWork::find($id);
    
        $msg_user_id = $job_work->user_id;
        $job = Job::find($job_work->job_id);
    
        $msg_title = $job->title;
    
        // Create a new UserMessage instance and save it to the database
        $data = new UserMessage();
        $data->user_id = $msg_user_id;
        $data->message_title = 'PROVE_REPORTED';
        $data->message = 'You Got Report " ' . $request->report_describe . ' " From: ' . $msg_title . ' -' . $job_work->id;
        $data->save();
        
        $data = new UserMessage();
        $data->user_id = Auth::user()->id;
        $data->message_title = 'SYSTEM_REPLY';
        $data->message = 'Thanks! We will review your report: (' . $request->report_describe . ')';
        $data->save();
    
        return redirect()->back()->with('message', 'Successfully reported this prove!');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'job_id' => 'required',
            'work_proof' => 'required',
        ]);

        $job = Job::find($request->job_id);
        $msg_title = $job->title;
        
        $job_woner = $job->user_id;
        //if($job->user_id == Auth::user()->id){
        //    return redirect()->back()->with('error','You can not work this job. This job posted by you!');
        //}

        $request->session()->forget('apply_error');
        $request->session()->flash('apply_error', true);
        
        $check_work_done = JobWork::where('job_id', $job->id)->where('status', '!=', 2)->count();
        if($check_work_done >= $job->worker_need){
            return redirect()->back();
        }

        $work = new JobWork();
        $work->job_id = $request->job_id;
        $work->work_proof = $request->work_proof;

        $images = $request->file('screenshot_proof');
        if ($images) {
            foreach($images as $image){
                $image_name = Str::random(20);
                $ext = strtolower($image->getClientOriginalExtension());
                $image_full_name = $image_name.'.'.$ext;
                $upload_path = 'backend/img/work-proof/';
                $image_url = $upload_path.$image_full_name;
                $success = $image->move($upload_path, $image_full_name);
                $uls[] = $image_url;
            }
            $screenshot = trim(implode("|",$uls),"|");

            $work->screenshot_proof = $screenshot;
        }

        $work->job_woner = $job_woner;
        $work->user_id = Auth::user()->id;
        $work->save();
        
        // Cleanup logic for images older than 7 days
        $sevenDaysAgo = now()->subDays(7);
    
        $files = Storage::files('backend/img/work-proof');
        
        foreach ($files as $file) {
            $fileLastModified = Storage::lastModified($file);
            
            if ($fileLastModified < $sevenDaysAgo) {
                Storage::delete($file);
            }
        }
        
       //  $data = new UserMessage();
       //  $data->user_id = $job_woner;
       //  $data->message_title = 'TASK_ATTEND';
       //  $data->message = 'Someone completed task of: '.$msg_title;
       //  $data->save();
       
        $request->session()->forget('apply_error');
        $request->session()->flash('apply_success', true);

        //return redirect()->route('user.job-work-confirm');
        return redirect()->back();
    }

    public function job_work_confirm()
    {
        return view('user.pages.work-done');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $job = JobWork::find($id);
        $job->delete();

        return redirect()->back()->with('message','Successfully deleted this job!');
    }
}
